#ifndef __DM_STRING_UTILS_H__
#define __DM_STRING_UTILS_H__

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"
#include <stdarg.h>
#ifdef __cplusplus
extern "C" {
#endif
////////////////////////////////////////////////////////////////////////////////

#define DECIMAL2BCD(d)                  (((((d)/10) << 4) & 0xf0) | (((d)%10)&0x0f))
#define BCD2DECIMAL(b)                  (((b)&0x0f) + 10*(((b)&0xf0)>>4))

////////////////////////////////////////////////////////////////////////////////

typedef enum
{
    STRING_ASCII,
    STRING_UTF8,
    STRING_UNICODE
} STRINGTYPE;

typedef struct
{
    STRINGTYPE type;
    UINT32 currCharCnt;
    UINT32 maxChars;
    UINT8 * pData;
} STRING;

typedef struct
{
    char * pStr;
    UINT32 num;
} STRNUMPAIR;

//	Console start
//	GetCmdArguments(INT8 *psrc, TYPE_ARG_STRUCT *pargv, UINT8 *argc, UINT8 maxarg) function conversion parameters
#define	CONSOLE_PAR_TYPE_UNDEF		0
#define	CONSOLE_PAR_TYPE_STR		1
#define	CONSOLE_PAR_TYPE_NUM		2
#define	CONSOLE_PAR_TYPE_UINT8		3
#define	CONSOLE_PAR_TYPE_UINT16		4
#define	CONSOLE_PAR_TYPE_UINT32		5
#define	CONSOLE_PAR_TYPE_UINT64		6
#define	MAX_CONSOLE_PAR_LNG_LEN		64
typedef	struct	{
	INT8	*argv;
	UINT32	parh;
	UINT32  parl;
	UINT32  pardec;
	UINT8	parlng[MAX_CONSOLE_PAR_LNG_LEN];
	UINT8	len;
	UINT8	type;
}	TYPE_ARG_STRUCT;

////////////////////////////////////////////////////////////////////////////////

extern void WordArrayToSpaceDelimitedAsciiHexString( UINT16* pNumArray, UINT32 lNumCount, char* pStringBuffer, UINT32 lStringBufferSize );
extern void ByteArrayToSpaceDelimitedAsciiHexString( UINT8* pNumArray, UINT32 lNumCount, char* pStringBuffer, UINT32 lStringBufferSize );

extern void SpaceDelimitedAsciiHexStringToWordArray( char* pStringBuffer, UINT32 lCharCount, UINT16* pWordArray, UINT32 lArraySize );
extern void SpaceDelimitedAsciiHexStringToByteArray( char* pStringBuffer, UINT32 lCharCount, UINT8* pByteArray, UINT32 lArraySize );

extern UINT8 AsciiHexToNumber(char * p);
extern UINT32 AsciiHexToNumberVariable(char * p);
extern char *ConvertIPAddressToStringZeropad(unsigned int IPAddress, char *AddressString, UINT32 addrStrLen);
extern UINT32 ConvertStringToIPAddress(char* AddressString);
extern void StringUnescapeQuotes(char * p);
extern UINT32 StringCommaDelimitedToArray(char * fieldNames[], UINT32 fieldNameCnt, char * linebuf);
extern char * StringLookupByString(char * key, char * keys[], char * values[], UINT32 valuesCnt);
extern INT32 ConvertStringToMacAddress(UINT8 * NewAddress, char * p);
extern char * ConvertMacAddressToString(char * p, UINT8 * NewAddress);
extern char * Seconds2HMS(char *DestString, UINT32 len, UINT32 seconds);
extern void StringRemoveQuotes(char * p);

extern INT32 StringGetNumber(STRNUMPAIR * pPairs, char * pDest, UINT32 * pNum, BOOL caseSensitive);
extern INT32 NumberGetString(STRNUMPAIR * pPairs, UINT32 num, char * pDest, UINT32 destLen);

extern INT32 StringParseArgs(char * cmd, char * argv[], UINT32 maxArgs, UINT32 * pArgc);
extern int stricmp(char const *s1, char const *s2);
extern char * StringTrim(char * pDest, char trimChar);
extern char * StringReplace(char * pDest, char oldChar, char newChar);
extern char * StringSub(char * pDest, char * pSrc, UINT32 startIdx, UINT32 len);
extern int strpos (char * s, char c);
extern char * StringFixedPointFormat(char * pDest, UINT32 destChars, INT32 val, INT32 div);
extern void StringPad(char * pSrc, char c, UINT32 len);
extern char * StringBin2Hex(char * pDest, UINT8 * pSrc, UINT32 byteCnt);
extern BOOL StringCharIsAlphanumeric(char c);
extern BOOL	ConvertASCIIStringtoHex (INT8 *psrc, UINT8 *pdata, UINT8 pdatalen);
extern void	GetCmdArguments (INT8 *psrc, TYPE_ARG_STRUCT *pargv, UINT8 *argc, UINT8 maxarg);
extern void	StringAdjustToWidth (INT8 *psrc, INT8 *pdst, UINT8 StrWidth);
extern BOOL IsCmdHelp (INT8 *pstr);

extern char* _strncpy(char *s1, const char *s2, int n);
extern char* _strncat(char *s1, const char *s2, int n);

extern const STRNUMPAIR HelpTypes[];
extern const STRNUMPAIR DeviceNames[];

#ifdef DM_WINCE
extern BOOL DmAllocateWideCharacterString( wchar_t** wcstr, const char* mbstr );
#endif

extern void ConvertCharStringToUpper(char *str);

#ifdef __cplusplus
}
#endif

#endif  //__DM_STRING_UTILS_H__



